/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class JarMain
implements Runnable {
    static final String MAIN = '/' + JarMain.class.getName().replace('.', '/') + ".class";
    protected final String[] args;
    protected final String archive;
    private final String path;
    protected File extractRoot;
    protected URLClassLoader classLoader;
    private static final boolean debug = Boolean.parseBoolean(JarMain.getSystemProperty("warbler.debug", "false"));

    JarMain(String[] args) {
        this.args = args;
        URL mainClass = this.getClass().getResource(MAIN);
        try {
            this.path = mainClass.toURI().getSchemeSpecificPart();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        this.archive = this.path.replace("!" + MAIN, "").replace("file:", "");
        Runtime.getRuntime().addShutdownHook(new Thread(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected URL[] extractArchive() throws Exception {
        JarFile jarFile = new JarFile(this.archive);
        try {
            HashMap<String, JarEntry> jarNames = new HashMap<String, JarEntry>();
            Enumeration<JarEntry> e = jarFile.entries();
            while (e.hasMoreElements()) {
                JarEntry entry = e.nextElement();
                String extractPath = this.getExtractEntryPath(entry);
                if (extractPath == null) continue;
                jarNames.put(extractPath, entry);
            }
            this.extractRoot = File.createTempFile("jruby", "extract");
            this.extractRoot.delete();
            this.extractRoot.mkdirs();
            ArrayList<URL> urls = new ArrayList<URL>(jarNames.size());
            for (Map.Entry e2 : jarNames.entrySet()) {
                URL entryURL = this.extractEntry((JarEntry)e2.getValue(), (String)e2.getKey());
                if (entryURL == null) continue;
                urls.add(entryURL);
            }
            URL[] uRLArray = urls.toArray(new URL[urls.size()]);
            return uRLArray;
        }
        finally {
            jarFile.close();
        }
    }

    protected String getExtractEntryPath(JarEntry entry) {
        String name = entry.getName();
        if (name.startsWith("META-INF/lib") && name.endsWith(".jar")) {
            return name.substring(name.lastIndexOf(47) + 1);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected URL extractEntry(JarEntry entry, String path) throws Exception {
        InputStream entryStream;
        File file = new File(this.extractRoot, path);
        if (entry.isDirectory()) {
            file.mkdirs();
            return null;
        }
        String entryPath = this.entryPath(entry.getName());
        try {
            entryStream = new URI("jar", entryPath, null).toURL().openStream();
        }
        catch (IllegalArgumentException e) {
            this.debug("failed to open jar:" + entryPath + " skipping entry: " + entry.getName(), e);
            return null;
        }
        File parent = file.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        FileOutputStream outStream = new FileOutputStream(file);
        byte[] buf = new byte[65536];
        try {
            int bytesRead;
            while ((bytesRead = entryStream.read(buf)) != -1) {
                outStream.write(buf, 0, bytesRead);
            }
        }
        finally {
            entryStream.close();
            outStream.close();
            file.deleteOnExit();
        }
        return file.toURI().toURL();
    }

    protected String entryPath(String name) {
        if (!name.startsWith("/")) {
            name = "/" + name;
        }
        return this.path.replace(MAIN, name);
    }

    protected Object newScriptingContainer(URL[] jars) throws Exception {
        JarMain.setSystemProperty("org.jruby.embed.class.path", "");
        this.classLoader = new URLClassLoader(jars);
        Class<?> scriptingContainerClass = Class.forName("org.jruby.embed.ScriptingContainer", true, this.classLoader);
        Object scriptingContainer = scriptingContainerClass.newInstance();
        this.debug("scripting container class loader urls: " + Arrays.toString(jars));
        JarMain.invokeMethod(scriptingContainer, "setArgv", new Object[]{this.args});
        JarMain.invokeMethod(scriptingContainer, "setClassLoader", new Class[]{ClassLoader.class}, new Object[]{this.classLoader});
        return scriptingContainer;
    }

    protected int launchJRuby(URL[] jars) throws Exception {
        Object scriptingContainer = this.newScriptingContainer(jars);
        this.debug("invoking " + this.archive + " with: " + Arrays.deepToString(this.args));
        Object outcome = JarMain.invokeMethod(scriptingContainer, "runScriptlet", this.launchScript());
        return outcome instanceof Number ? ((Number)outcome).intValue() : 0;
    }

    protected String launchScript() {
        return "begin\n  require 'META-INF/init.rb'\n  require 'META-INF/main.rb'\n  0\nrescue SystemExit => e\n  e.status\nend";
    }

    protected int start() throws Exception {
        URL[] jars = this.extractArchive();
        return this.launchJRuby(jars);
    }

    protected void debug(String msg) {
        this.debug(msg, null);
    }

    protected void debug(String msg, Throwable t) {
        if (JarMain.isDebug()) {
            System.out.println(msg);
        }
        if (JarMain.isDebug() && t != null) {
            t.printStackTrace(System.out);
        }
    }

    protected static void debug(Throwable t) {
        JarMain.debug(t, System.out);
    }

    private static void debug(Throwable t, PrintStream out) {
        if (JarMain.isDebug()) {
            t.printStackTrace(out);
        }
    }

    protected void warn(String msg) {
        System.out.println("WARNING: " + msg);
    }

    protected static void error(Throwable t) {
        JarMain.error(t.toString(), t);
    }

    protected static void error(String msg, Throwable t) {
        System.err.println("ERROR: " + msg);
        JarMain.debug(t, System.err);
    }

    protected void delete(File f) {
        try {
            if (f.isDirectory() && !this.isSymlink(f)) {
                File[] children = f.listFiles();
                for (int i = 0; i < children.length; ++i) {
                    this.delete(children[i]);
                }
            }
            f.delete();
        }
        catch (IOException e) {
            JarMain.error(e);
        }
    }

    protected boolean isSymlink(File file) throws IOException {
        File canonical;
        if (file == null) {
            throw new NullPointerException("File must not be null");
        }
        if (file.getParent() == null) {
            canonical = file;
        } else {
            File parentDir = file.getParentFile().getCanonicalFile();
            canonical = new File(parentDir, file.getName());
        }
        return !canonical.getCanonicalFile().equals(canonical.getAbsoluteFile());
    }

    public void run() {
        try {
            JarMain.invokeMethod((Object)this.classLoader, "close", new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (Exception e) {
            JarMain.error(e);
        }
        if (this.extractRoot != null) {
            this.delete(this.extractRoot);
        }
    }

    public static void main(String[] args) {
        JarMain.doStart(new JarMain(args));
    }

    protected static void doStart(JarMain main) {
        int exit;
        try {
            exit = main.start();
        }
        catch (Exception e) {
            Throwable t;
            for (t = e; t.getCause() != null && t.getCause() != t; t = t.getCause()) {
            }
            JarMain.error(e.toString(), t);
            exit = 1;
        }
        try {
            if (JarMain.isSystemExitEnabled()) {
                System.exit(exit);
            }
        }
        catch (SecurityException e) {
            JarMain.debug(e);
        }
    }

    protected static Object invokeMethod(Object self, String name, Object ... args) throws NoSuchMethodException, IllegalAccessException, Exception {
        Class[] signature = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            signature[i] = args[i].getClass();
        }
        return JarMain.invokeMethod(self, name, signature, args);
    }

    protected static Object invokeMethod(Object self, String name, Class[] signature, Object ... args) throws NoSuchMethodException, IllegalAccessException, Exception {
        Method method = self.getClass().getDeclaredMethod(name, signature);
        try {
            return method.invoke(self, args);
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            if (target instanceof Exception) {
                throw (Exception)target;
            }
            throw e;
        }
    }

    static boolean isDebug() {
        return debug;
    }

    private static boolean isSystemExitEnabled() {
        return JarMain.getSystemProperty("warbler.skip_system_exit") == null;
    }

    static String getSystemProperty(String name) {
        return JarMain.getSystemProperty(name, null);
    }

    static String getSystemProperty(String name, String defaultValue) {
        try {
            return System.getProperty(name, defaultValue);
        }
        catch (SecurityException e) {
            return defaultValue;
        }
    }

    static boolean setSystemProperty(String name, String value) {
        try {
            System.setProperty(name, value);
            return true;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    static String getENV(String name) {
        return JarMain.getENV(name, null);
    }

    static String getENV(String name, String defaultValue) {
        try {
            if (System.getenv().containsKey(name)) {
                return System.getenv().get(name);
            }
            return defaultValue;
        }
        catch (SecurityException e) {
            return defaultValue;
        }
    }
}

